

/*
const byte AN_IN1_PIN            = A2;
const byte AN_IN2_PIN            = A3;


 * Commands
 * 
 * [ZENTER] - user has entered the sensor TAB in the app. Turn both LEDs on
 * [ZEXIT] - user has left the sensor TAB. Turn both LEDs off. The waiting LED should start to flash
 * [ZX] - operation aborted. Stand down.
 * 
 * Sensor 1. Analogue sensor
 * [Z1ON] - sensor 1 has been turned on in the app
 * [Z1OF] - sensor 1 has been turned off in the app
 * [Z1H2L] - set H2L trigger value
 * [Z1L2H] - set L2H trigger value
 * [Z1Txnnnn] - set trigger value
 * [Z1GO] - arm sensor 1
 * 
 * Sensor 2. Digital sensor
 * [Z2ON] - sensor 2 has been turned on in the app
 * [Z2OF] - sensor 2 has been turned off in the app
 * [Z2GO] - arm sensor 2
 * [Z2Tn] - sensor 2 trigger value (0 or 1 / LOW or HIGH)
 * 
 * 
 * Camera
 * [ZCOFF]     - Camera is off
 * [ZCAnnnnppp] - A = Trigger on ACTIVATE
 * [ZCSnnnnppp] - S = Trigger on sensor tripping
 * 
 * Flash
 * [ZF10]   [ZF111234ppp]
 *  
 * [ZG]  - Trigger Test  
 * Need to have the camera and flash control codes.
 *  
 *  
 *  Out Commands
 *  [Xnnnn] Analogue sensor value
 *  [Wn]    Digital sensor value
 *  [ZZ]    Triggered
 *  
 */

// Variables used for sensor mode       ************************************************

unsigned int Sensor1TriggerVal = 0;
bool Sensor2TriggerVal = LOW;
unsigned int sennsor1Val = 0;
bool sennsor2Val = LOW; 
boolean sensor1isActive = false;
boolean sensor2isActive = false;
boolean sensor1IsArmed = false;
boolean sensor2IsArmed = false;
unsigned int oldVal = 0;
bool oldVal2 = LOW;
unsigned int delayCounter = 0;
unsigned int delayCounter2 = 0;

boolean highToLow = false;
boolean lowToHigh = false;
unsigned int temp = 0; 

bool useFlash1 = false;
bool useCamera = false;

unsigned int cameraStart = 0;
unsigned int cameraStop = 0;
unsigned int cameraPulse = 50;

unsigned int flash1Start = 0;
unsigned int flash1Pulse = 50;
unsigned int flash1Stop = 0;

bool cameraOpen = false;
bool flash1Open = false;
bool bulbMode = false; 

unsigned long timeStart = 0;
unsigned long timeStop = 0;
unsigned long timeNow = 0;
unsigned long timeUsed = 0;

bool sensorModeFinished = false;


void sensorMode()
{

    //sensorActive = true;
    digitalWrite(LED_ACTIVE_PIN, HIGH);


   // init variables
   sensorModeFinished = false;
   sensor1isActive = false;
   sensor2isActive = false;
   sensor1IsArmed = false;
   sensor2IsArmed = false;
   oldVal = 0;

   highToLow = false;
   lowToHigh = false;
   useCamera = false;
   useFlash1 = false;
   bulbMode = false;
   cameraOpen = false;
   flash1Open = false;

   delayCounter = 0;
   delayCounter2 = 0;


    // main sensor loop
    while (!sensorModeFinished)
    {

      // timeStart = micros();
      
      // Analogue sensor - Using a prescale of 16 the below has an overhead of around 40us when sensor 1 is active. This is about 25,000 samples per second. (used basic measuremnts only. when delayCounter > 3000).
      // Without the prescale the speed is around 128us/132us.
      // Could spped the loop slightly by removing the call to recvWithStartEndMarkersBT(). I left it in becuase will need this when developing the Android app.
      // 
      // Digital sensor - around 24us. This is about 41,500 samples per second.

      // I will look at speed improvements later. The fastest method will require direct pin access and free runing ADC. This will limit the compatible hardware

      
      recvWithStartEndMarkersUSB();
      recvWithStartEndMarkersBT(); 
      if (haveNewData) { processSensorCommands(); }
 
      if (sensor1isActive)
      {
            // read analogue sensor.
            sennsor1Val = analogRead(AN_IN1_PIN);    

            if (sensor1IsArmed)
            {
                 if (highToLow && sennsor1Val <= Sensor1TriggerVal )  { trigger(); sensor1IsArmed = false;  }               // H2L
                 if (lowToHigh && sennsor1Val >= Sensor1TriggerVal )  { trigger(); sensor1IsArmed = false;  }               // L2H
            }

            if (sennsor1Val != oldVal)
            {
                  // Send the sensor value to app. 
                  //  - Only send if the value has changed
                  //  - No need to send every reading. Just need enough to keep the app updated.
                  // If faster speed is required can remove send values to the app. This will give 4-8us improvement per loop.
                  
                  delayCounter ++;
                  if (delayCounter > 4000) // only 1 in 4000 reading are sent to the app. This is around 5 times a second. 
                  {
                      delayCounter = 0;

                      // Serial.write is quicker then Serial.print.
                      Serial.write(91);   // 91 = [
                      Serial.write(88);   // 88 = X
          
                      if (sennsor1Val < 1000) { Serial.write(48);}  // 48 = '0'
                      if (sennsor1Val < 100)  { Serial.write(48);}
                      if (sennsor1Val < 10)   { Serial.write(48);}           
                      Serial.print( sennsor1Val );
                      //Serial.write( highByte( sennsor1Val ) );
                      //Serial.write( lowByte ( sennsor1Val ) );
                      Serial.write(93);   // 93 = ]
                      
                      oldVal = sennsor1Val;
                  }

            }  //  if (sennsor1Val != oldVal)
            
      }  // if (sensor1isActive)


      if (sensor2isActive)
      {
           sennsor2Val = digitalRead(AN_IN2_PIN);

           if (sensor2IsArmed) {  if (sennsor2Val == Sensor2TriggerVal) { trigger(); sensor2IsArmed = false; }     }

           // Only send if the value has changed
           if (sennsor2Val != oldVal2)
           {
              oldVal2 = sennsor2Val;
              Serial.write(91);   // 91 = [
              Serial.write(87);   // 87 = W
              Serial.print( sennsor2Val );
              Serial.write(93);   // 93 = ]
           }
      }



  

/*
    timeStop= micros();   
    if (sensor1isActive)
    {
         delayCounter2++;
         if (delayCounter2 > 3000)
         {
            delayCounter2 = 0;
            timeUsed = timeStop - timeStart;
            Serial.print("[M, time="); Serial.print(timeUsed); Serial.print("us]"); 
         }

    }
*/    
    
    
    
      
    }// sensorModeFinished == true. Back to the main program. 

    // Leaving Sensor Mode so turn off the ACTIVE LED
    digitalWrite(LED_ACTIVE_PIN, LOW);
} 


void readAndSendSensorValue(byte val = 0)
{

    if (val == 1)
    {
        sennsor1Val = analogRead(AN_IN1_PIN); 
        Serial.write(91);   // 91 = [
        Serial.write(88);   // 88 = X
        
        if (sennsor1Val < 1000) { Serial.write(48);}  // 48 = '0'
        if (sennsor1Val < 100)  { Serial.write(48);}
        if (sennsor1Val < 10)   { Serial.write(48);}           
        Serial.print( sennsor1Val );
        Serial.write(93);   // 93 = ]
        oldVal = sennsor1Val;
    }
    if (val == 2)
    {
           sennsor2Val = digitalRead(AN_IN2_PIN);
           oldVal2 = sennsor2Val;
           Serial.write(91);   // 91 = [
           Serial.write(87);   // 87 = W
           Serial.print( sennsor2Val );
           Serial.write(93);   // 93 = ]
    }
  
}






/***
 *      _          _                             ____  
 *     | |        (_)                           / /\ \ 
 *     | |_  _ __  _   __ _   __ _   ___  _ __ | |  | |
 *     | __|| '__|| | / _` | / _` | / _ \| '__|| |  | |
 *     | |_ | |   | || (_| || (_| ||  __/| |   | |  | |
 *      \__||_|   |_| \__, | \__, | \___||_|   | |  | |
 *                     __/ |  __/ |             \_\/_/ 
 *                    |___/  |___/                     
 */


void trigger()
{
    
    if(bulbMode) { useCamera=false; }
    
    bool triggerCompleted = false;
    if (useCamera==false && useFlash1==false) { triggerCompleted = true;}

    flash1Open = false;
    cameraOpen = false;

    
    cameraStop = cameraStart + cameraPulse;   // Add correct pulse value later 
    flash1Stop = flash1Start + flash1Pulse;   // Add correct pulse value later 

      
    timeStart = millis();

    while (!triggerCompleted)
    {
        
        if (useCamera == true) 
        {  
           timeNow = millis();
           if (!cameraOpen) {  if (timeNow-timeStart >= cameraStart) { digitalWrite(CT_FOCUS_PIN, HIGH); digitalWrite(CT_SHUTTER_PIN , HIGH); cameraOpen = true;  }  }
           if (cameraOpen)  {  if (timeNow-timeStart >= cameraStop)  { digitalWrite(CT_FOCUS_PIN, LOW);  digitalWrite(CT_SHUTTER_PIN , LOW);  cameraOpen = false;  useCamera = false; }  }
        }

        if (useFlash1 == true) 
        {
            timeNow = millis();
            if (!flash1Open) { if (timeNow-timeStart >= flash1Start) { digitalWrite(FT1_PIN, HIGH);  flash1Open = true; }  }
            if (flash1Open)  { if (timeNow-timeStart >= flash1Stop)  { digitalWrite(FT1_PIN, LOW);   flash1Open = false; useFlash1 = false; }  }
        }
        
        if (useCamera==false && useFlash1==false) { triggerCompleted = true;}
    }


    if(bulbMode) { delay(50); digitalWrite(CT_FOCUS_PIN, LOW);  digitalWrite(CT_SHUTTER_PIN , LOW);  }


   if (sensor1isActive)
   {
        Serial.write(91);   // 91 = [
        Serial.write(88);   // 88 = X
        if (sennsor1Val < 1000) { Serial.write(48);}  // 48 = '0'
        if (sennsor1Val < 100)  { Serial.write(48);}
        if (sennsor1Val < 10)   { Serial.write(48);}           
        Serial.print( sennsor1Val );
        Serial.write(93);   // 93 = ]
   }
   if (sensor2isActive)
   {
         Serial.write(91);   // 91 = [
         Serial.write(87);   // 87 = W
         Serial.print( sennsor2Val );
         Serial.write(93);   // 93 = ]
   }



    // send trigger fired notifier 
    Serial.print(F( "[ZZ]" ));

    Serial.print("[M,Triggered: sensor 1 = "); Serial.print(sennsor1Val); Serial.print("]");
    
}














/***
 *                                               _____                                  _____                                                _        ____  
 *                                              / ____|                                / ____|                                              | |      / /\ \ 
 *      _ __   _ __  ___    ___  ___  ___  ___ | (___    ___  _ __   ___   ___   _ __ | |      ___   _ __ ___   _ __ ___    __ _  _ __    __| | ___ | |  | |
 *     | '_ \ | '__|/ _ \  / __|/ _ \/ __|/ __| \___ \  / _ \| '_ \ / __| / _ \ | '__|| |     / _ \ | '_ ` _ \ | '_ ` _ \  / _` || '_ \  / _` |/ __|| |  | |
 *     | |_) || |  | (_) || (__|  __/\__ \\__ \ ____) ||  __/| | | |\__ \| (_) || |   | |____| (_) || | | | | || | | | | || (_| || | | || (_| |\__ \| |  | |
 *     | .__/ |_|   \___/  \___|\___||___/|___/|_____/  \___||_| |_||___/ \___/ |_|    \_____|\___/ |_| |_| |_||_| |_| |_| \__,_||_| |_| \__,_||___/| |  | |
 *     | |                                                                                                                                           \_\/_/ 
 *     |_|                                                                                                                                                  
 */


void processSensorCommands()
{

    if (strcmp(receivedChars, "ZX")  == 0)
    {
      // ABORT
      sensor1IsArmed = false;
      sensor2IsArmed = false;
      haveNewData = false;
      receivedChars[0] = '\0';
    } 


    // [ZEXIT]  when the Sensor Tab in the app is closed the app sends [ZEXIT]
    else if (strcmp(receivedChars, "ZEXIT")  == 0) 
    {
         digitalWrite(LED_ACTIVE_PIN, LOW);
         digitalWrite(CT_FOCUS_PIN, LOW);  
         digitalWrite(CT_SHUTTER_PIN , LOW);
         
         sensor1isActive = false;
         sensor1isActive = false;
         sensorModeFinished = true;
    
         haveNewData = false;
         receivedChars[0] = '\0';
    }

    // [Z1GO] Sensor 1 has been activated
    else if (strcmp(receivedChars, "Z1GO")  == 0)
    {
      // ARM the trigger
      sensor1IsArmed = true;
  
      haveNewData = false;
      receivedChars[0] = '\0';
    } 
  
    // [Z2GO] Sensor 1 has been activated
    else if (strcmp(receivedChars, "Z2GO")  == 0)
    {
      // ARM the trigger
      sensor2IsArmed = true;

      haveNewData = false;
      receivedChars[0] = '\0';
    } 
  
 



/*
 *                                           __                                                        _      
 *                                          /_ |                                                      | |     
 *      ___   ___  _ __   ___   ___   _ __   | |    ___  ___   _ __ ___   _ __ ___    __ _  _ __    __| | ___ 
 *     / __| / _ \| '_ \ / __| / _ \ | '__|  | |   / __|/ _ \ | '_ ` _ \ | '_ ` _ \  / _` || '_ \  / _` |/ __|
 *     \__ \|  __/| | | |\__ \| (_) || |     | |  | (__| (_) || | | | | || | | | | || (_| || | | || (_| |\__ \
 *     |___/ \___||_| |_||___/ \___/ |_|     |_|   \___|\___/ |_| |_| |_||_| |_| |_| \__,_||_| |_| \__,_||___/
 */
    //   sensor 1 command
    else if ( receivedChars[1] == '1')
    {
  
  
          //  [Z1ON] sensor 1 has been turned ON             
          if ( receivedChars[2] == 'O'  & receivedChars[3] == 'N')
          {
             sensor1isActive = true;
             haveNewData = false;
             receivedChars[0] = '\0';

             // do an initial sensor read and send the value to the app
             readAndSendSensorValue(1);
          }
  
          //  [Z1OF] sensor 1 has been turned OFF           
          else if ( receivedChars[2] == 'O'  & receivedChars[3] == 'F')
          {
             sensor1isActive = false;
             haveNewData = false;
             receivedChars[0] = '\0';
          }
  
  
          // [Z1Txxxx] - set sensor 1 trigger value
          else if ( receivedChars[2] == 'T' )  
          {
             temp =        (receivedChars[3] - 48) * 1000;
             temp = temp + (receivedChars[4] - 48) * 100;
             temp = temp + (receivedChars[5] - 48) * 10;
             temp = temp +  receivedChars[6] - 48;
             Sensor1TriggerVal = temp;
  
             haveNewData = false;
             receivedChars[0] = '\0';

          }
  
   
          // [Z1H2L] - set H2L trigger value
          // [Z1L2H] - set L2H trigger value
          else if (strcmp(receivedChars, "Z1H2L")  == 0)
          {
            highToLow = true;
            lowToHigh = false;
            haveNewData = false;
            receivedChars[0] = '\0';
          }   
           
          else if (strcmp(receivedChars, "Z1L2H")  == 0)
          {
            highToLow = false;
            lowToHigh = true;
            haveNewData = false;
            receivedChars[0] = '\0';
          }  
  
    }  // if ( receivedChars[1] == '1')








/***
 *                                           ___                                                         _      
 *                                          |__ \                                                       | |     
 *      ___   ___  _ __   ___   ___   _ __     ) |    ___  ___   _ __ ___   _ __ ___    __ _  _ __    __| | ___ 
 *     / __| / _ \| '_ \ / __| / _ \ | '__|   / /    / __|/ _ \ | '_ ` _ \ | '_ ` _ \  / _` || '_ \  / _` |/ __|
 *     \__ \|  __/| | | |\__ \| (_) || |     / /_   | (__| (_) || | | | | || | | | | || (_| || | | || (_| |\__ \
 *     |___/ \___||_| |_||___/ \___/ |_|    |____|   \___|\___/ |_| |_| |_||_| |_| |_| \__,_||_| |_| \__,_||___/
 */

    //   sensor 2 commands
    else if ( receivedChars[1] == '2')
    
    {
          //  [Z2ON] Sensor 2 has been turned ON         
          if ( receivedChars[2] == 'O'  & receivedChars[3] == 'N')
          {
             sensor2isActive = true;
             haveNewData = false;
             receivedChars[0] = '\0';

             // do an initial sensor read and send the value to the app
             readAndSendSensorValue(2);
          }
  
          //  [Z2OF] Sensor 2 has been turned OFF
          else if ( receivedChars[2] == 'O'  & receivedChars[3] == 'F')
          {
             sensor2isActive = false;
             haveNewData = false;
             receivedChars[0] = '\0';
  
          }
  

          //  [Z2Tn] Sensor 2 trigger value
          else if ( receivedChars[2] == 'T' )
          {
             haveNewData = false;
             receivedChars[0] = '\0';
  
             if (receivedChars[3] == '0') { Sensor2TriggerVal = LOW;  }
             else                         { Sensor2TriggerVal = HIGH; }
          }
     
    }  //   if ( receivedChars[1] = '2')






/***
 *                                                            __  _              _     
 *                                                  ___      / _|| |            | |    
 *       ___  __ _  _ __ ___    ___  _ __  __ _    ( _ )    | |_ | |  __ _  ___ | |__  
 *      / __|/ _` || '_ ` _ \  / _ \| '__|/ _` |   / _ \/\  |  _|| | / _` |/ __|| '_ \ 
 *     | (__| (_| || | | | | ||  __/| |  | (_| |  | (_>  <  | |  | || (_| |\__ \| | | |
 *      \___|\__,_||_| |_| |_| \___||_|   \__,_|   \___/\/  |_|  |_| \__,_||___/|_| |_|
 */

    //  CAMERA   
    //  [ZCOFF] Camera is OF (not used)
    //  [ZCB0000ppp] Bulb mode
    //  [ZCS0000ppp] Sensor mode - trigger the camera when the sensor triggers
    
    else if ( receivedChars[1] == 'C' )
    {
         if ( receivedChars[2] == 'O' ) {useCamera = false; }
         else 
         {
             useCamera = true;
             // Camera trigger delay time
             temp =        (receivedChars[3] - 48) * 1000;
             temp = temp + (receivedChars[4] - 48) * 100;
             temp = temp + (receivedChars[5] - 48) * 10;
             temp = temp +  receivedChars[6] - 48;
             cameraStart = temp;

             // Camera trigger pulse time
             temp =        (receivedChars[7] - 48) * 100;
             temp = temp + (receivedChars[8] - 48) * 10;
             temp = temp +  receivedChars[9] - 48;
             cameraPulse = temp;


             
  
             if ( receivedChars[2] == 'S' )    { bulbMode = false;   }  
             else                              { digitalWrite(CT_FOCUS_PIN, HIGH); digitalWrite(CT_SHUTTER_PIN , HIGH); bulbMode = true;  }  

             //   'S' = SENSOR MODE -  fire the camera when the sensor trips
             //   'B' = BULB MODE   - start the camera on the ACTIVATE button click and close after the sensor trips
          }
       
          haveNewData = false;
          receivedChars[0] = '\0';
    }

    

    //  FLASH  1
    //  [ZF1OFF] Flash1 is OF
    //  [ZF1nnnnppp]
    else if ( receivedChars[1] == 'F' )
    {
          if ( receivedChars[3] == 'O' )   {  useFlash1 = false;    }
          else
          {
               useFlash1 = true;
               // Flash delay
               temp =        (receivedChars[3] - 48) * 1000;
               temp = temp + (receivedChars[4] - 48) * 100;
               temp = temp + (receivedChars[5] - 48) * 10;
               temp = temp +  receivedChars[6] - 48;
               flash1Start = temp;

               // Flash trigger pulse time

               temp =        (receivedChars[7] - 48) * 100;
               temp = temp + (receivedChars[8] - 48) * 10;
               temp = temp +  receivedChars[9] - 48;
               flash1Pulse = temp;

               
          }
          haveNewData = false;
          receivedChars[0] = '\0';
    }


    // Trigger Test
    else if (strcmp(receivedChars, "ZG")  == 0)
    {
      trigger();
      haveNewData = false;
      receivedChars[0] = '\0';
    } 


} //processSensorCommands()



  









  































